import sys
import bisect
from collections import defaultdict

input = sys.stdin.readline

# Fenwick (BIT) ?? ????????
class Fenwick:
    def __init__(self, n):
        self.n = n
        self.bit = [0] * (n + 2)

    def add(self, i, v):
        while i <= self.n:
            self.bit[i] += v
            i += i & -i

    def sum(self, i):
        s = 0
        while i > 0:
            s += self.bit[i]
            i -= i & -i
        return s


# ????? ???????? [l, r] ?? ????????? v
def add_interval(fw, l, r, v):
    if l > r:
        return
    fw.add(l, v)
    fw.add(r + 1, -v)


# ?????? ?????? ????? ???????? ?? ???? ????????
def remove_pos(fw, pos_list, pos, val):
    i = bisect.bisect_left(pos_list, pos)

    prev = pos_list[i - 1] if i - 1 >= 0 else None
    nxt = pos_list[i + 1] if i + 1 < len(pos_list) else None

    # ???????? ????? ?????????
    if prev is None:
        l = pos
    else:
        l = prev

    if nxt is None:
        r = n
    else:
        r = nxt - 1

    if i % 2 == 0:
        add_interval(fw, l, r, -val)
    else:
        add_interval(fw, l, r, val)

    # ???????? ????? ??????? ???????? ??? ???????
    if prev is not None and nxt is not None:
        if (i - 1) % 2 == 0:
            add_interval(fw, prev, nxt - 1, val)
        else:
            add_interval(fw, prev, nxt - 1, -val)


# ????? ???????? ?? ???? ????????
def add_pos(fw, pos_list, pos, val):
    i = bisect.bisect_left(pos_list, pos)

    prev = pos_list[i - 1] if i - 1 >= 0 else None
    nxt = pos_list[i] if i < len(pos_list) else None

    if prev is not None and nxt is not None:
        if (i - 1) % 2 == 0:
            add_interval(fw, prev, nxt - 1, -val)
        else:
            add_interval(fw, prev, nxt - 1, val)

    if prev is None:
        l = pos
    else:
        l = prev

    if nxt is None:
        r = n
    else:
        r = nxt - 1

    if i % 2 == 0:
        add_interval(fw, l, r, val)
    else:
        add_interval(fw, l, r, -val)

    pos_list.insert(i, pos)


# ---- MAIN ----

n, q = map(int, input().split())
a = [0] + list(map(int, input().split()))

fw = Fenwick(n)
pos = defaultdict(list)

# ???????????????
for i in range(1, n + 1):
    add_pos(fw, pos[a[i]], i, a[i])

# ?????? ?????
for _ in range(q):
    data = list(map(int, input().split()))
    if data[0] == 1:
        x = data[1]
        print(fw.sum(x))
    else:
        _, i, y = data
        old = a[i]

        # ?????? ????? ????????
        remove_pos(fw, pos[old], i, old)
        pos[old].remove(i)

        # ????? ???? ????????
        add_pos(fw, pos[y], i, y)
        a[i] = y